%{
  open Ast
%}

%token Lfalse Ltrue
%token Land Lor Lnot
%token Lopar Lcpar
%token Leof

%left Lor
%left Land
%right Lnot

%start prog

%type <Ast.expr> prog

%%

prog:
| expr Leof { $1 }
;

expr:
| expr Land expr   { And ($1, $3) }
| expr Lor expr    { Or  ($1, $3) }
| Lnot expr        { Not ($2) }
| Lopar expr Lcpar { $2 }
| Lfalse           { Bit (false) }
| Ltrue            { Bit (true) }
;
