  .text
  .globl main

##########################################
factloop_handwritten:
  lw $t0, 0($sp)
  li $v0, 1
flh_loop:
  beqz $t0, flh_endloop
  mul $v0, $t0, $v0
  addi $t0, $t0, -1
  b flh_loop
flh_endloop:
  jr $ra
##########################################

##########################################
factloop_compiled_naive:
  addi $sp, $sp, -12 # reserve space for $ra + $fp + r
  sw $ra, 8($sp)     # push $ra
  sw $fp, 4($sp)     # push $fp
  move $fp, $sp      # $fp local

  li $v0, 1          # 1
  sw $v0, 0($fp)     # r =

loop001:
  lw $v0, 12($fp)    # n
  addi $sp, $sp, -4
  sw $v0, 0($sp)     # push n
  li $v0, 0          # 0
  addi $sp, $sp, -4
  sw $v0, 0($sp)     # push 0
  jal __gt           # call >
  addi $sp, $sp, 8   # pop n, pop 0

  beqz $v0, endloop001

  lw $v0, 12($fp)    # n
  addi $sp, $sp, -4
  sw $v0, 0($sp)     # push n
  lw $v0, 0($fp)     # r
  addi $sp, $sp, -4
  sw $v0, 0($sp)     # push r
  jal __mul          # call *
  addi $sp, $sp, 8   # pop n, pop r
  sw $v0, 0($fp)     # r =

  lw $v0, 12($fp)    # n
  addi $sp, $sp, -4
  sw $v0, 0($sp)     # push n
  li $v0, 1          # 1
  addi $sp, $sp, -4
  sw $v0, 0($sp)     # push 1
  jal __sub          # call -
  addi $sp, $sp, 8   # pop n, pop 1
  sw $v0, 12($fp)    # n =

  b loop001
endloop001:
  lw $v0, 0($fp)     # r

  lw $ra, 8($sp)     # pop $ra
  lw $fp, 4($sp)     # pop $fp
  addi $sp, $sp, 12  # free space of $ra + $fp + r
  jr $ra
##########################################

##########################################
__gt:
  lw $t0, 0($sp)
  lw $t1, 4($sp)
  sgt $v0, $t1, $t0
  jr $ra
__mul:
  lw $t0, 0($sp)
  lw $t1, 4($sp)
  mul $v0, $t1, $t0
  jr $ra
__sub:
  lw $t0, 0($sp)
  lw $t1, 4($sp)
  sub $v0, $t1, $t0
  jr $ra
##########################################

main:
  addi $sp, $sp, -4
  sw $ra, 0($sp) # push ra

  # print "n? "
  li $v0, 4
  la $a0, question
  syscall

  # read n
  li $v0, 5
  syscall

  # push n
  addi $sp, $sp, -4
  sw $v0, 0($sp)

  # call factloop
  jal factloop_compiled_naive  # CHOIX ICI

  # pop n
  addi $sp, $sp, 4

  move $t0, $v0 # backup result

  # print "n! = "
  li $v0, 4
  la $a0, result
  syscall

  # print result
  move $a0, $t0
  li $v0, 1
  syscall

  # print "\n"
  li $v0, 4
  la $a0, nl
  syscall

  # return 0
  li $v0, 0

  lw $ra, 0($sp) # pop ra
  addi $sp, $sp, 4
  jr $ra

  .data
question: .asciiz "n? "
result: .asciiz "n! = "
nl: .asciiz "\n"
