let eval expr =
  let lst = String.split_on_char ' ' expr in
  let cmd = List.hd lst in
  let args = List.map String.to_int (List.tl lst) in
  match cmd with
  | "num"  -> Some (List.hd args)
  | "exit" -> None
  | _ ->
     Printf.eprintf "Error: unknown command '%s'.\n" cmd ;
     None

let rec repl invite =
  Printf.printf "%s" invite ;
  let user_input = read_line () in
  match eval user_input with
  | Some n -> Printf.printf "%d\n" n ;
              repl invite
  | None   -> Printf.eprintf "Bye.\n"

let () = repl "> "
